var carrier;
var modulator;

function setup() {
    createCanvas(300, 300);
    useSound();
}

function soundSetup() { // setup for audio generation
    carrier = new p5.Oscillator();
    carrier.setType('sine');
    carrier.start();
    modulator = new p5.Oscillator();
    modulator.setType('sine');
    modulator.disconnect();
    modulator.start();
}

function draw() {
    background(200);
    fill(0);
    ellipse(mouseX, mouseY, 20, 20);
    modulator.amp(constrain(440 * (mouseY / height), 0, 440));
    modulator.freq(constrain(440 * (mouseX / width), 0, 440));
    carrier.amp(0.5);
    carrier.freq(modulator);
    if (mouseX > 2*width) {
        carrier.stop();
        noLoop();
    }
}